//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Dialogs  1.1

import wesual.Create   1.0
import wesual.Ui        1.0
import wesual.data.Core 1.0

import wesual.module.MediaManager  1.0

Rectangle {
    id : button

    property string imageSource
    property Document document         //: imageSourcePicker.document
    property alias selectMultiple   : imageSourcePicker.selectMultiple
    property bool removeWithNullSelection //:
        //imageSourcePicker.removeWithNullSelection
    signal selectedImages(var images)

    signal navigateToProduct()

    implicitWidth    : 100
    implicitHeight   : 100
    activeFocusOnTab : !image.visible

    function openMenuOnKeyPress() {
//        imageSourcePicker.x = Math.round(image.width  / 2);
//        imageSourcePicker.y = Math.round(image.height / 2);
        imageSourcePicker.show();
    }

    // key handling
    Keys.onReturnPressed : openMenuOnKeyPress()
    Keys.onEnterPressed  : openMenuOnKeyPress()

    border {
        width : 1
        color : UiColors.getColor(UiColors.ControlGrey20)
    }

    color : {
        if (image.visible)
            return UiColors.getColor(UiColors.White);

        if (imageMouseArea.pressed/* || imageSourcePicker.popupVisible*/)
            return UiColors.getColor(UiColors.SelectionGreen);
        else if (imageMouseArea.containsMouse || button.activeFocus)
            return UiColors.getColor(UiColors.HoverGreen);
        else
            return UiColors.getColor(UiColors.White);
    }

    AssetThumbnail  {
        id : image

        anchors.fill    : parent
        asset : {
            if (!document) {
                return null;
            } else if(document.type === "asset:image") {
                return document;
            } else {
                return document.primaryImage;
            }
        }
        visible : imageSource.toString() !== ""
    }
    Image {
        sourceSize {
            width  : 24
            height : 24
        }
        width : 24
        height : 24
        anchors.centerIn : parent
        source : "qrc:/controls/icons/add.png"
        visible : !image.visible
    }
    MouseArea {
        id : imageMouseArea
        anchors.fill : parent
        acceptedButtons : image.visible ?
                              Qt.RightButton : Qt.LeftButton | Qt.RightButton
        hoverEnabled : enabled
        onClicked : {
            if (image.visible) {
                options.clickPosition = Qt.point(mouse.x, mouse.y);
                options.show();
            } else {
                imageSourcePicker.show();
            }
        }
    }

    MouseArea {
        id : doubleClickArea
        anchors.fill : parent
        acceptedButtons : image.visible ? Qt.LeftButton : 0

        onDoubleClicked : {
            navigateToProduct();
        }
    }

    MediaLocationDialog {
        id : imageSourcePicker

        selectMultiple : false
        onAccepted : selectedImages(result);
    }
    ContextMenu {
        id : options

        items : [
            Action {
                id : uploadAction
                text : qsTrId("26e3dacd662ab645")
                onTriggered : imageSourcePicker.show()
            }
        ]
    }

    UiDropZone {
        id : assetDrop

        anchors.fill : parent

        UiImageDropHandler {
            onDrop : importer.importFiles(data)
        }
    }

    AssetImportDialog {
        id : importer

        context : Creator.context
        onAccepted : {
            document.beginRecordChanges();
            button.selectedImages(result);
            document.endRecordChanges();
        }
    }
}

